/*
	The file contains an example of how to use the routines hij() and 
	perm_test() which are contained in the file "hij.c".

	Written by Hans Julius Skaug, September 6. 1994
 
	Please direct any question or comment to:
 
	Hans Julius Skaug
	Department of Mathematics
	University of Bergen
	5007 BERGEN
	NORWAY
                
	email: skaug@mi.uib.no
*/

#include <stdio.h>
#include "hij.h"

#define q 5

main()
/*
	Example of how to use hij() and perm_test().
*/
{
	int i;
	double X[N] = {1.3,2.2,-1.6,-0.5,2.1,2.4,3.3,0.7,-0.3,1.2};	
			/* Note: N is defined in the file "hij.h" */
	double H[q], I[q], J[q], tmp[6*(q+1)], P_H, P_I, P_J;

	hij(X,N,0.5,H,I,J,q,tmp,-2.0,2.0);

	printf(" The values of the statistics are:\n\n");

	for ( i=1; i <= q-1; i++ )
		printf("H[%d] = %f	I[%d] = %f	J[%d] = %f\n",
					i,H[i],i,I[i],i,J[i]);

	perm_test(X,N,0.5,&P_H,&P_I,&P_J,q,tmp,-2.0,2.0);


	printf("\n\nThe values of the conditional p-values:\n\n");

	printf("P_H[%d] = %f	P_I[%d] = %f	P_J[%d] = %f\n",
					q,P_H,q,P_I,q,P_J);

}
